'use strict';

const { skip, isWindows, isIBMi } = require('../common');
const assert = require('assert');
const { spawnSync } = require('child_process');
const { isMainThread } = require('worker_threads');

if (!isMainThread) {
  skip('process.execve is not available in Workers');
} else if (isWindows || isIBMi) {
  skip('process.execve is not available in Windows or IBM i');
}

if (process.argv[2] === 'child') {
  process.execve(
    process.execPath + '_non_existing',
    [__filename, 'replaced'],
    { ...process.env, EXECVE_A: 'FIRST', EXECVE_B: 'SECOND', CWD: process.cwd() }
  );
} else {
  const child = spawnSync(`${process.execPath}`, [`${__filename}`, 'child']);
  const stderr = child.stderr.toString();

  assert.ok(stderr.includes('process.execve failed with error code ENOENT'), stderr);
  assert.ok(stderr.includes('execve (node:internal/process/per_thread'), stderr);
}
