'use strict';

const { skip, isWindows, isIBMi } = require('../common');
const assert = require('assert');
const { isMainThread } = require('worker_threads');
const { dirname, join } = require('path');
const { existsSync } = require('fs');

if (!isMainThread) {
  skip('process.execve is not available in Workers');
} else if (isWindows || isIBMi) {
  skip('process.execve is not available in Windows or IBM i');
}

// Get full path to the executable used for the test
const executable = join(dirname(process.execPath), 'nop');

// Sanity check that the binary exists
if (!existsSync(executable)) {
  skip(executable + ' binary is not available');
}

process.execve(executable);
// If process.execve succeeds, this should never be executed.
assert.fail('process.execve failed');
