'use strict';

const common = require('../common');
const { Readable, Writable } = require('stream');
const { finished } = require('stream/promises');

const bench = common.createBenchmark(main, {
  n: [1e7],
  streamType: ['readable', 'writable'],
});

async function main({ n, streamType }) {
  bench.start();

  for (let i = 0; i < n; i++) {
    let stream;

    switch (streamType) {
      case 'readable':
        stream = new Readable({ read() { this.push(null); } });
        stream.resume();
        break;
      case 'writable':
        stream = new Writable({ write(chunk, enc, cb) { cb(); } });
        stream.end();
        break;
    }

    await finished(stream);
  }

  bench.end(n);
}
