// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

'use strict';
const common = require('../common');
const assert = require('assert');
const fs = require('fs');

const tmpdir = require('../common/tmpdir');

tmpdir.refresh();
const FILENAME = tmpdir.resolve('watch-me');
const TIMEOUT = 1300;

let nevents = 0;

try {
  fs.unlinkSync(FILENAME);
} catch {
  // swallow
}

fs.watchFile(FILENAME, { interval: TIMEOUT - 250 }, common.mustCall((curr, prev) => {
  console.log([curr, prev]);
  switch (++nevents) {
    case 1:
      assert.strictEqual(fs.existsSync(FILENAME), false);
      break;
    case 2:
    case 3:
      assert.strictEqual(fs.existsSync(FILENAME), true);
      break;
    case 4:
      assert.strictEqual(fs.existsSync(FILENAME), false);
      fs.unwatchFile(FILENAME);
      break;
    default:
      assert(0);
  }
}, 4));

process.on('exit', function() {
  assert.strictEqual(nevents, 4);
});

setTimeout(createFile, TIMEOUT);

function createFile() {
  console.log('creating file');
  fs.writeFileSync(FILENAME, 'test');
  setTimeout(touchFile, TIMEOUT);
}

function touchFile() {
  console.log('touch file');
  fs.writeFileSync(FILENAME, 'test');
  setTimeout(removeFile, TIMEOUT);
}

function removeFile() {
  console.log('remove file');
  fs.unlinkSync(FILENAME);
}
